/* -LICENSE-START-
 ** Copyright (c) 2015 Blackmagic Design
 **
 ** Permission is hereby granted, free of charge, to any person or organization
 ** obtaining a copy of the software and accompanying documentation covered by
 ** this license (the "Software") to use, reproduce, display, distribute,
 ** execute, and transmit the Software, and to prepare derivative works of the
 ** Software, and to permit third-parties to whom the Software is furnished to
 ** do so, all subject to the following:
 **
 ** The copyright notices in the Software and this entire statement, including
 ** the above license grant, this restriction and the following disclaimer,
 ** must be included in all copies of the Software, in whole or in part, and
 ** all derivative works of the Software, unless such copies or derivative
 ** works are solely in the form of machine-executable object code generated by
 ** a source language processor.
 **
 ** THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 ** IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 ** FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
 ** SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
 ** FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
 ** ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 ** DEALINGS IN THE SOFTWARE.
 ** -LICENSE-END-
 */
#pragma once

#include <QColor>

class ColourPalette
{
	public:

		static const QColor kColour1;
		static const QColor kColour2;
		static const QColor kColour3;

		static const QString kColour1Str() { return toHtmlQString(kColour1); }
		static const QString kColour2Str() { return toHtmlQString(kColour2); }
		static const QString kColour3Str() { return toHtmlQString(kColour3); }

		static const QColor kColour4;
		static const QColor kColour5;
		static const QColor kColour6;
		static const QColor kColour7;
		static const QColor kColour8;

		static const QColor kColour9;

		static const QString kColour4Str() { return toHtmlQString(kColour4); }
		static const QString kColour5Str() { return toHtmlQString(kColour5); }
		static const QString kColour6Str() { return toHtmlQString(kColour6); }
		static const QString kColour7Str() { return toHtmlQString(kColour7); }
		static const QString kColour8Str() { return toHtmlQString(kColour8); }
		static const QString kColour9Str() { return toHtmlQString(kColour9); }

		static QString toHtmlQString(const QColor& colour);
		static QString toHtmlQString(const QColor& colour, int alpha);

		static QString processStyleSheet(const char* styleSheet);
};

